% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switchboard.R
\name{switchboard}
\alias{switchboard}
\title{Initialize a switchboard window}
\usage{
switchboard(
  title = "hidden title",
  delay = 0,
  skip = 0,
  padX = 10,
  padY = 0,
  font = "Helvetica",
  mainColors = c("#007fff", "#ffffff", "#666666", "#cccccc")
)
}
\arguments{
\item{title}{The title of the switchboard Tcl/Tk window. Switchboards hide
the titlebar, but is can be un-hidden by adding a title (e.g., \code{title = "my new title"}.}

\item{delay}{Pause each update of the switchboard. Default has no delay,
values are in seconds (e.g., \code{delay = 0.01} results in 0.01 second
delay with each iteration).}

\item{skip}{Skips updating the switchboard. The default does not skip updates,
values are in number of iterations to skip (e.g., \code{skip = 50} results
in updates only occurring after every 50 iterations).}

\item{padX}{Horizontal padding in pixels between widgets.}

\item{padY}{Vertical padding in pixels between widgets.}

\item{font}{The primary font used in all widgets, default is "Helvetica".}

\item{mainColors}{The color set used in all widgets. It is a vector of four
hex colors with each element corresponding to: c("main color", "background",
"text color", "alt text color").}
}
\description{
The \code{switchboard} initializes a switchboard window, then using \code{\%>\%}
you can pipe in various widgets into this window to create a dashboard.
}
\examples{
\dontrun{

   for(i in 1:100)
      switchboard(delay = 0.05) \%>\%
      progress_ibis(i, maximum = 100, closeAtMaximum = TRUE)

}

}
\seealso{
Other dashboard: 
\code{\link{showGrid}()},
\code{\link{switchboard_close}()}
}
\concept{dashboard}
