% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stSimulate.R
\name{stSimulate}
\alias{stSimulate}
\title{Simulate responses from the spatio-temporal teleconnection model}
\usage{
stSimulate(dat.train, dat.test, coords.knots, params, miles = T)
}
\arguments{
\item{dat.train}{stData object with training data to simulate new Y values for}

\item{dat.test}{stData object with test data to simulate new Y values for}

\item{coords.knots}{matrix with coordinates of knots for remote covariates
(lon, lat)}

\item{params}{A list containing model parameters for use in simulation
\describe{
  \item{beta}{ vector with fixed effect coefficients }
  \item{cov.s}{ list(smoothness=double, range=double, variance=double, nugget=double) }
  \item{cov.r}{ list(smoothness=double, range=double, variance=double, nugget=double) }
}}

\item{miles}{TRUE to compute distances for evaluating covariance functions 
in miles.  This is important since the interpretations of the cov.r and 
cov.s parameters depend on the units with which distance is measured.}
}
\description{
This function simulates spatio-temporal data. The intention is that data Y and latent 
parameters alpha will be generated using provided covariates X and Z; 
spatial domains coords.s, coords.r, and coords.knots; and model parameters.
}
\examples{
set.seed(2018)
  
data("coprecip")
data("coprecip.fit")

coprecip.predict = stPredict(stFit = coprecip.fit, stData = coprecip, 
                             stDataNew = coprecip, burn = 90, 
                             returnFullAlphas = FALSE)
}
