% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{rm_regexp_match}
\alias{rm_regexp_match}
\title{Delete rows in a text.table where the record has a certain pattern indicated by a regular expression}
\usage{
rm_regexp_match(x, text, pattern)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x used to determine deletion of rows based on the regular expression.}

\item{pattern}{A regular expression, gets passed to grepl().}
}
\value{
A text.table, with rows having a certain pattern indicated by a regular expression deleted.
}
\description{
Delete rows in a text.table where the record has a certain pattern indicated by a regular expression
}
\examples{
rm_regexp_match(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2",
pattern = "do"
)
}
