% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_decay_optimizers.R
\name{extend_with_decoupled_weight_decay}
\alias{extend_with_decoupled_weight_decay}
\title{Factory function returning an optimizer class with decoupled weight decay}
\usage{
extend_with_decoupled_weight_decay(base_optimizer)
}
\arguments{
\item{base_optimizer}{An optimizer class that inherits from tf$optimizers$Optimizer.}
}
\value{
A new optimizer class that inherits from DecoupledWeightDecayExtension and base_optimizer.
}
\description{
Factory function returning an optimizer class with decoupled weight decay
}
\details{
The API of the new optimizer class slightly differs from the API of the base optimizer:

- The first argument to the constructor is the weight decay rate.
- minimize and apply_gradients accept the optional keyword argument decay_var_list,
which specifies the variables that should be decayed. If NULLs, all variables that are optimized are decayed.
}
\note{
Note: this extension decays weights BEFORE applying the update based
on the gradient, i.e. this extension only has the desired behaviour for
optimizers which do not depend on the value of 'var' in the update step!
Note: when applying a decay to the learning rate, be sure to manually apply
the decay to the `weight_decay` as well.
}
\examples{

\dontrun{

### MyAdamW is a new class
MyAdamW = extend_with_decoupled_weight_decay(tf$keras$optimizers$Adam)
### Create a MyAdamW object
optimizer = MyAdamW(weight_decay = 0.001, learning_rate = 0.001)
#### update var1, var2 but only decay var1
optimizer$minimize(loss, var_list = list(var1, var2), decay_variables = list(var1))

}

}
