% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_mcc}
\alias{metric_mcc}
\title{MatthewsCorrelationCoefficient}
\usage{
metric_mcc(
  num_classes = NULL,
  name = "MatthewsCorrelationCoefficient",
  dtype = tf$float32
)
}
\arguments{
\item{num_classes}{Number of unique classes in the dataset.}

\item{name}{(Optional) String name of the metric instance.}

\item{dtype}{(Optional) Data type of the metric result. Defaults to `tf$float32`.}
}
\value{
Matthews correlation coefficient: float
}
\description{
Computes the Matthews Correlation Coefficient.
}
\details{
The statistic is also known as the phi coefficient.
The Matthews correlation coefficient (MCC) is used in
machine learning as a measure of the quality of binary
and multiclass classifications. It takes into account
true and false positives and negatives and is generally
regarded as a balanced measure which can be used even
if the classes are of very different sizes. The correlation
coefficient value of MCC is between -1 and +1. A
coefficient of +1 represents a perfect prediction,
0 an average random prediction and -1 an inverse
prediction. The statistic is also known as
the phi coefficient. MCC = (TP * TN) - (FP * FN) / ((TP + FP) * (TP + FN) * (TN + FP ) * (TN + FN))^(1/2) Usage:
}
\examples{

\dontrun{

actuals = tf$constant(list(1, 1, 1, 0), dtype=tf$float32)
preds = tf$constant(list(1,0,1,1), dtype=tf$float32)
# Matthews correlation coefficient
mcc = metric_mcc(num_classes=1)
mcc$update_state(actuals, preds)
paste('Matthews correlation coefficient is:', mcc$result()$numpy())
# Matthews correlation coefficient is : -0.33333334

}


}
