% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{outliers.tfm}
\alias{outliers.tfm}
\alias{outliers}
\alias{outliers.um}
\title{Outliers detection at known/unknown dates}
\usage{
\method{outliers}{tfm}(
  mdl,
  y = NULL,
  dates = NULL,
  c = 3,
  calendar = FALSE,
  easter = FALSE,
  resid = c("exact", "cond"),
  n.ahead = NULL,
  p.value = 1,
  envir = NULL,
  ...
)

outliers(mdl, ...)

\method{outliers}{um}(
  mdl,
  z = NULL,
  dates = NULL,
  c = 3,
  calendar = FALSE,
  easter = FALSE,
  resid = c("exact", "cond"),
  n.ahead = 0,
  p.value = 1,
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{y}{an object of class \code{ts}}

\item{dates}{a list of dates c(year, season). If \code{dates = NULL}, an
iterative detection process is conducted.}

\item{c}{a positive constant to compare the z-ratio of the effect of an
observation and decide whether or not it is an outlier. This argument is
only used when \code{dates = NULL}.}

\item{calendar}{logical; if true, calendar effects are also estimated.}

\item{easter}{logical; if true, Easter effect is also estimated.}

\item{resid}{type of residuals (exact or conditional) used to identify 
outliers.}

\item{n.ahead}{a positive integer to extend the sample period of the
intervation variables with \code{n.ahead} observations, which could be
necessary to forecast the output.}

\item{p.value}{estimates with a p-value greater than p.value are omitted.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}

\item{...}{additional arguments.}

\item{z}{a time series.}
}
\value{
an object of class "\code{\link{tfm}}" or a table.
}
\description{
\code{outliers} performs a detection of four types of anomalies (AO, TC, LS
and IO) in a time series described by an ARIMA model. If the dates of the
outliers are unknown, an iterative detection process like that proposed by
Chen and Liu (1993) is conducted.
}
\examples{
Y <- rsales
um1 <- um(Y, i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
outliers(um1)
}
