% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_spec.R
\name{layer_input_from_dataset}
\alias{layer_input_from_dataset}
\title{Creates a list of inputs from a dataset}
\usage{
layer_input_from_dataset(dataset)
}
\arguments{
\item{dataset}{a TensorFlow dataset or a data.frame}
}
\value{
a list of Keras input layers
}
\description{
Create a list ok Keras input layers that can be used together
with \code{\link[keras:layer_dense_features]{keras::layer_dense_features()}}.
}
\examples{
\dontrun{
library(tfdatasets)
data(hearts)
hearts <- tensor_slices_dataset(hearts) \%>\% dataset_batch(32)

# use the formula interface
spec <- feature_spec(hearts, target ~ age + slope) \%>\%
  step_numeric_column(age, slope) \%>\%
  step_bucketized_column(age, boundaries = c(10, 20, 30))

spec <- fit(spec)
dataset <- hearts \%>\% dataset_use_spec(spec)

input <- layer_input_from_dataset(dataset)
}

}
