% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{dt_separate}
\alias{dt_separate}
\title{Separate columns with data.table}
\usage{
dt_separate(
  dt_,
  col,
  into,
  sep = ".",
  remove = TRUE,
  fill = NA,
  fixed = TRUE,
  immutable = TRUE,
  ...
)
}
\arguments{
\item{dt_}{the data table (or if not a data.table then it is coerced with as.data.table)}

\item{col}{the column to separate}

\item{into}{the names of the new columns created from splitting \code{col}.}

\item{sep}{the regular expression stating how \code{col} should be separated. Default is \code{.}.}

\item{remove}{should \code{col} be removed in the returned data table? Default is \code{TRUE}}

\item{fill}{if empty, fill is inserted. Default is \code{NA}.}

\item{fixed}{logical. If TRUE match split exactly, otherwise use regular expressions. Has priority over perl.}

\item{immutable}{If \code{TRUE}, \code{.dt} is treated as immutable (it will not be modified in place). Alternatively, you can set \code{immutable = FALSE} to modify the input object.}

\item{...}{arguments passed to \code{data.table::tstrplit()}}
}
\value{
A data.table with a column split into multiple columns.
}
\description{
Separates a column of data into others, by splitting based a separator or regular expression
}
\examples{

library(data.table)
d <- data.table(x = c("A.B", "A", "B", "B.A"),
                y = 1:4)

# defaults
dt_separate(d, x, c("c1", "c2"))

# can keep the original column with `remove = FALSE`
dt_separate(d, x, c("c1", "c2"), remove = FALSE)

# need to assign when `immutable = TRUE`
separated <- dt_separate(d, x, c("c1", "c2"), immutable = TRUE)
separated

# don't need to assign when `immutable = FALSE` (default)
dt_separate(d, x, c("c1", "c2"), immutable = FALSE)
d

}
