% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{dt_starts_with}
\alias{dt_starts_with}
\alias{dt_contains}
\alias{dt_ends_with}
\alias{dt_everything}
\title{Select helpers}
\usage{
dt_starts_with(match)

dt_contains(match)

dt_ends_with(match)

dt_everything()
}
\arguments{
\item{match}{a character string to match to variable names}
}
\value{
None. To be used within the \verb{dt_pivot_*} functions.
}
\description{
These functions allow you to select variables based on their names.
\itemize{
\item \code{dt_starts_with()}: Starts with a prefix
\item \code{dt_starts_with()}: Ends with a suffix
\item \code{dt_contains()}: Contains a literal string
\item \code{dt_everything()}: Matches all variables
}
}
\examples{
library(data.table)

# example of using it with `dt_pivot_longer()`
df <- data.table(row = 1, var = c("x", "y"), a = 1:2, b = 3:4)
pv <- dt_pivot_wider(df,
                     names_from = var,
                     values_from = c(dt_starts_with("a"), dt_ends_with("b")))

}
