% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{db_meta_get_latest_validity}
\alias{db_meta_get_latest_validity}
\title{Get Latest Validity for Metadata of a Given Time Series}
\usage{
db_meta_get_latest_validity(
  con,
  ts_keys,
  regex = FALSE,
  locale = NULL,
  schema = "timeseries"
)
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{regex}{\strong{boolean} indicating if ts_keys should be interpreted as a regular expression pattern. Defaults to FALSE.}

\item{locale}{\strong{character} indicating the language of the meta information to be store. We recommend to use ISO country codes to represent languages. Defaults to NULL. When local is set to NULL, metadata are stored without localization. Note that, when localizing meta information by assigning a language, multiple meta information objects can be stored for a single time series.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
data.table of latest validity
}
\description{
Because metadata are only loosely coupled with their respective time series
in order to keep metadata records constant over multiple version of
time series if the data description does not change, it comes in
handy to find out the last time meta information was updated. This function
automagickally finds exactly this date.
}
\seealso{
Other metadata functions: 
\code{\link{db_collection_read_metadata}()},
\code{\link{db_dataset_read_metadata}()},
\code{\link{db_metadata_read}()},
\code{\link{db_metadata_store}()}
}
\concept{metadata functions}
