% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_time_series.R
\name{db_ts_trim_history}
\alias{db_ts_trim_history}
\title{Remove Vintages from the Beginning}
\usage{
db_ts_trim_history(con, ts_keys, older_than, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{older_than}{Date cut off point}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\description{
Removes any vintages of the given time series that are older than a specified date.
}
\details{
In some cases only the last few versions of time series are of interest. This
function can be used to trim off old vintages that are no longer relevant.
}
\examples{

\dontrun{

# Store different versions of the time series data
ch.kof.barometer <- kof_ts["baro_2019m11"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2019-12-01",
  schema = "schema"
)

ch.kof.barometer <- kof_ts["baro_2019m12"]
names(ch.kof.barometer) <- c("ch.kof.barometer")
db_ts_store(
  con = connection,
  ch.kof.barometer,
  valid_from = "2020-01-01",
  schema = "schema"
)

db_ts_trim_history(
  con = connection,
  ts_keys = "ch.kof.barometer",
  older_than = "2019-12-31",
  schema = "schema"
)
}
}
\seealso{
Other time series functions: 
\code{\link{db_collection_read_ts}()},
\code{\link{db_dataset_read_ts}()},
\code{\link{db_ts_delete_latest_version}()},
\code{\link{db_ts_delete}()},
\code{\link{db_ts_get_last_update}()},
\code{\link{db_ts_read_history}()},
\code{\link{db_ts_read}()},
\code{\link{db_ts_store}()}
}
\concept{time series functions}
