% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-selection.R
\name{grid_click}
\alias{grid_click}
\title{Click event (in shiny)}
\usage{
grid_click(grid, inputId)
}
\arguments{
\item{grid}{A table created with \code{\link[=datagrid]{datagrid()}}.}

\item{inputId}{The \code{input} slot that will be used to access the value.}
}
\value{
A \code{datagrid} htmlwidget.
}
\description{
Click event (in shiny)
}
\examples{
if (interactive()) {
  library(shiny)
  library(toastui)

  ui <- fluidPage(
    tags$h2("datagrid click"),
    datagridOutput("grid"),
    verbatimTextOutput("res")
  )

  server <- function(input, output, session) {

    df <- data.frame(
      index = 1:12,
      month = month.name,
      letters = letters[1:12]
    )

    output$grid <- renderDatagrid({
      datagrid(df) \%>\%
        grid_click(
          inputId = "click"
        )
    })

    output$res <- renderPrint({
      input$click
    })
  }

  shinyApp(ui, server)
}
}
