% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_view_as_complex}
\alias{torch_view_as_complex}
\title{View_as_complex}
\usage{
torch_view_as_complex(self)
}
\arguments{
\item{self}{(Tensor) the input tensor.}
}
\description{
View_as_complex
}
\section{view_as_complex(input) -> Tensor }{


Returns a view of \code{input} as a complex tensor. For an input complex
tensor of \code{size} \eqn{m1, m2, \dots, mi, 2}, this function returns a
new complex tensor of \code{size} \eqn{m1, m2, \dots, mi} where the last
dimension of the input tensor is expected to represent the real and imaginary
components of complex numbers.
}

\section{Warning}{

\link{torch_view_as_complex} is only supported for tensors with
\code{torch_dtype} \code{torch_float64()} and \code{torch_float32()}.  The input is
expected to have the last dimension of \code{size} 2. In addition, the
tensor must have a \code{stride} of 1 for its last dimension. The strides of all
other dimensions must be even numbers.
}

\examples{
if (torch_is_installed()) {
if (FALSE) {
x=torch_randn(c(4, 2))
x
torch_view_as_complex(x)
}
}
}
