% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_survreg.R
\name{importance.survreg}
\alias{importance.survreg}
\title{Create a variable importance plot for a survreg model}
\usage{
\method{importance}{survreg}(model_final, model_data, dict = NA, nperm = 500, ...)
}
\arguments{
\item{model_final}{a model object}

\item{model_data}{the data used to fit the model}

\item{dict}{a plotting dictionary for models terms}

\item{nperm}{the number of permutations used to calculate the importance}

\item{...}{arguments passed to other methods}
}
\value{
an object of type \code{importance_plot}
\item{type}{the type of importance plot}
\item{data}{the importance data required for the plot}
}
\description{
Create a variable importance plot for a survreg model
}
\examples{
model_final <- survival::survreg(survival::Surv(futime, fustat) ~ ecog.ps*rx + age,
                       data = survival::ovarian,
                       dist = "weibull")
imp <- importance(model_final, survival::ovarian, nperm = 500)
plot(imp)
}
\seealso{
\code{\link{importance}}
}
