% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackFunctions.R
\name{findMaxCost}
\alias{findMaxCost}
\title{Find maximum tracking cost}
\usage{
findMaxCost(particles, frame = 1, colorimages = NULL)
}
\arguments{
\item{particles}{Object of class 'particles', obtained using \code{identifyParticles}.}

\item{frame}{Number specifying which frame to use. Default is frame 1.}

\item{colorimages}{Array containing original color images. By default,
the original color images are obtained from the global environment.}
}
\value{
Returns the number that is interactively chosen by the user. Use
this value in \code{trackParticles}.
}
\description{
This function can help to find a appropriate maximum value for linking
a particle to another particle (parameter L in function \code{trackParticles})
}
\examples{
\dontrun{
partIden <- identifyParticles(sbg=allImages,
                              threshold=-0.05)
maxcost <- findMaxCost(partIden,frame=1)
records <- trackParticles(partIden,L=maxcost,R=1)
}
}
\author{
Marjolein Bruijning
}
