% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackFunctions.R
\name{mergeTracks}
\alias{mergeTracks}
\title{Merge track records}
\usage{
mergeTracks(records1, records2, L = NULL, weight = NULL, logsizes = FALSE)
}
\arguments{
\item{records1}{Object of class 'tracked',
obtained using \code{\link{trackParticles}}.}

\item{records2}{Object of class 'tracked',
obtained using \code{\link{trackParticles}} that should be linked to
\code{records1}.}

\item{L}{Numeric. Maximum cost for linking a particle to another particle.
When the cost is larger,
particles will be not be linked (resulting in the begin or end of a segment).
If \code{NULL}, the same \code{L} as used to create
\code{records2} is used.}

\item{weight}{Vector containing 3 weights to calculate costs. Depending
on the study system user may want to value certain elements over others.
Weights are ordered as follows;
first number gives the weight for differences in x and y coordinates;
second number
gives the weight for particle size differences. Note that the
difference between the predicted location and the observed location is
not taken into account in this function. If \code{NULL}, the same weights as
used to create \code{records2} is used.}

\item{logsizes}{Logical. Default is \code{FALSE}. Set to \code{TRUE} to take the
natural logarithm of body sizes, when calculating the cost of linking two particles.}
}
\value{
A list of class 'TrDm' and 'records'. Use 'summary' and 'plot'.
}
\description{
\code{mergeTracks} attempts to merge to two track objects as obtained by
\code{\link{trackParticles}}.
}
\examples{
\dontrun{
## Create image sequence
dir.create("images")
traj <- simulTrajec(path="images",
                    nframes=60,nIndividuals=20,domain="square",
                    h=0.01,rho=0.9,sizes=runif(20,0.004,0.006))
## Analyse first part
dir <- "images"
allFullImages1 <- loadImages (dirPictures=dir,nImages=1:30)
stillBack1 <- createBackground(allFullImages1)
allImages1 <- subtractBackground(bg=stillBack1)
partIden1 <- identifyParticles(sbg=allImages1,
                              pixelRange=c(1,500),
                              threshold=-0.1)
records1 <- trackParticles(partIden1,L=20,R=2)
## Analyse second part
allFullImages2 <- loadImages (dirPictures=dir,nImages=31:60)
stillBack2 <- createBackground(allFullImages2)
allImages2 <- subtractBackground(bg=stillBack2)
partIden2 <- identifyParticles(sbg=allImages2,
                              pixelRange=c(1,500),
                              threshold=-0.1)
records2 <- trackParticles(partIden2,L=20,R=2)
## Merge tracks
records <- mergeTracks(records1,records2)
plot(records,colorimages=allFullImages1,type="trajectories",incThres=10)
}
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
