% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liver_scores.R
\name{soft}
\alias{soft}
\title{SOFT score (Survival Outcomes Following Liver Transplantation)}
\usage{
soft(Age, BMI, PrevTx, AbdoSurg, Albumin, Dx, ICU, Admitted, MELD,
  LifeSupport, Encephalopathy, PVThrombosis, Ascites, PortalBleed,
  DonorAge, DonorCVA, DonorSCr, National, CIT, Units = "SI")
}
\arguments{
\item{Age}{numeric vector of patient ages in years}

\item{BMI}{numeric vector of patient BMI in kg/m2}

\item{PrevTx}{numeric vector of number of previous transplants}

\item{AbdoSurg}{numeric vector of whether previous abdominal surgery (1 = "yes", 0 = "no")}

\item{Albumin}{numeric vector of serum albumin in g/l}

\item{Dx}{numeric vector of whether on dialysis before transplant (1 = "yes", 0 = "no")}

\item{ICU}{numeric vector of whether patients in intensive care unit before transplant (1 = "yes", 0 = "no")}

\item{Admitted}{numeric vector of whether admitted to hospital pre-transplant (1 = "yes", 0 = "no")}

\item{MELD}{numeric vector of MELD scores}

\item{LifeSupport}{numeric vector of whether on life support pre-transplant (1 = "yes", 0 = "no")}

\item{Encephalopathy}{numeric vector of whether encephalopathy present (1 = "yes", 0 = "no")}

\item{PVThrombosis}{numeric vector of whether portal vein thrombosis (1 = "yes", 0 = "no")}

\item{Ascites}{numeric vector of whether ascites pre-transplant (1 = "yes", 0 = "no")}

\item{PortalBleed}{numeric vector of whether portal bleeding in 48 hours pre-transplant (1 = "yes", 0 = "no")}

\item{DonorAge}{numeric vector of donor ages in years}

\item{DonorCVA}{numeric vector of whether donor cause of death is CVA/stroke (1 = "yes", 0 = "no")}

\item{DonorSCr}{numeric vector of donor terminal serum creatinine}

\item{National}{numeric vector of whether national allocation (1 = "yes", 0 = "no")}

\item{CIT}{numeric vector of cold ischaemic time in hours}

\item{Units}{units to use for creatinine and albumin, "SI" (default) for µmol/l and g/l, "US" for mg/dl and g/dl}
}
\value{
numeric vector of SOFT Scores
}
\description{
A vectorised function to calculate SOFT Scores for predicting patient survival after liver
transplantation The units for donor serum creatinine are in µmol/l
and recipient serum albumin in g/l but they can be changed to mg/dl and g/dl respectively
by setting the Units parameter to "US".
}
\details{
Reference: Rana A, Hardy MA, Halazun KJ, et al. Survival Outcomes Following Liver Transplantation
(SOFT) Score: A Novel Method to Predict Patient Survival Following Liver Transplantation.
American Journal of Transplantation 2008; 8:2537-2546.
}
\examples{
soft(Age = 35, BMI = 20, PrevTx = 0, AbdoSurg = 1, Albumin = 30, Dx = 0,
    ICU = 0, Admitted = 0, MELD = 29, LifeSupport = 0, Encephalopathy = 1,
    PVThrombosis = 0, Ascites = 1, PortalBleed = 0, DonorAge = 44, DonorCVA = 0,
    DonorSCr = 110, National = 0, CIT = 8) # 7
}
