% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-filter.R
\name{filter_bk}
\alias{filter_bk}
\title{Baxter-King Filter}
\usage{
filter_bk(x, fill = NA, ...)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{fill}{\verb{[numeric or function: NA]}

Numeric value(s) or function used to fill observations.}

\item{...}{Further arguments passed to \code{\link[mFilter]{bkfilter}}.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

This function computes the cyclical component of the Baxter-King filter.
}
\examples{
\donttest{
unemp <- ggplot2::economics$unemploy
unemp_cycle <- filter_bk(unemp)
plotx(cbind(unemp, unemp_cycle))
}
}
