% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfcusum.R
\name{dfcusum}
\alias{dfcusum}
\title{Distribution Free CUSUM Test}
\usage{
dfcusum(x,startyear)
}
\arguments{
\item{x}{- Time series data vector}

\item{startyear}{- Starting of the time series (year!)}
}
\value{
CUMSUM values - Cumulative sum series

Maximum CUMSUM Value  - Absolute Maximum value in cumulative sum series

90 percent CI - Critical value at 90 percent Confidence Interval (1.228*sqrt(n))

95 percent CI - Critical value at 95 percent Confidence Interval (1.36*sqrt(n))

99 percent CI - Critical value at 99 percent Confidence Interval (1.63*sqrt(n))
}
\description{
Distribution free CUSUM test is used to identify the change point in a series of data.
}
\details{
The point at which Maximum value of cumulative sum occurs, will indicate the change point in the time series. If the maximum value is equal to or greater than the critical value, it indicates significance of the change point.
}
\examples{
x<-c(Nile)
dfcusum(x,1871)

}
\references{
Grayson, R.B., Argent, R.M., Nathan, R.J., McMahon, T.A. and Mein, R., 1996 Hydrological Recipes: Estimation Techniques in Australian Hydrology. Cooperative Research Centre for Catchment Hydrology, Australia, 125 pp.
}
