% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{Centre}
\alias{Centre}
\title{Compositional Centre}
\usage{
Centre(P)
}
\arguments{
\item{P}{n by m matrix of compositions {p1, ..., pm}_i for i=1,...,n.}
}
\value{
The centre of P as an m element numeric vector.
}
\description{
Calculate the centre of a compositional data set.
}
\examples{
P <- prop.table(matrix(runif(300), 100), margin = 1)
tricolore:::Centre(P)

}
\references{
Von Eynatten, H., Pawlowsky-Glahn, V., & Egozcue, J. J. (2002).
Understanding perturbation on the simplex: A simple method to better
visualize and interpret compositional data in ternary diagrams.
Mathematical Geology, 34(3), 249-257.

Pawlowsky-Glahn, V., Egozcue, J. J., & Tolosana-Delgado, R. (2007). Lecture
Notes on Compositional Data Analysis. Retrieved from
https://dugi-doc.udg.edu/bitstream/handle/10256/297/CoDa-book.pdf
}
\keyword{internal}
