% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtransforms.R
\name{plot,Vtransform,missing-method}
\alias{plot,Vtransform,missing-method}
\title{Plot method for Vtransform class}
\usage{
\S4method{plot}{Vtransform,missing}(
  x,
  type = "transform",
  shading = TRUE,
  npoints = 200,
  lower = 0,
  upper = 1
)
}
\arguments{
\item{x}{an object of class \linkS4class{Vtransform}.}

\item{type}{type of plot: 'transform' for plot of transform, 'inverse' for plot of inverse,
'gradient' for plot of gradient or 'pdown' for plot of conditional probability.}

\item{shading}{logical variable specifying whether inadmissible zone for v-transform
should be shaded}

\item{npoints}{number of plotting points along x-axis.}

\item{lower}{the lower x-axis value for plotting.}

\item{upper}{the upper x-axis value for plotting}
}
\value{
No return value, generates plot.
}
\description{
Plots the v-transform as well as its gradient or inverse. Can also plot the
conditional probability that a series PIT falls below the fulcrum for a
given volatility PIT value v.
}
\examples{
plot(Vsymmetric())
plot(V2p(delta = 0.45, kappa = 0.8), type = "inverse")
plot(V2p(delta = 0.45, kappa = 0.8), type = "gradient")
}
