% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{gafa_stock}
\alias{gafa_stock}
\title{GAFA stock prices}
\format{
Time series of class \code{tsibble}
}
\source{
Yahoo Finance historical data
}
\description{
Historical stock prices from 2014-2018 for Google, Amazon, Facebook and Apple.
All prices are in $USD.
}
\details{
\code{gafa_stock} is a \code{tsibble} containing data on irregular trading days:
\tabular{ll}{
Open:      \tab The opening price for the stock.\cr
High:      \tab The stock's highest trading price.\cr
Low:       \tab The stock's lowest trading price.\cr
Close:     \tab The closing price for the stock.\cr
Adj_Close: \tab The adjusted closing price for the stock.\cr
Volume:    \tab The amount of stock traded.\cr
}

Each stock is uniquely identified by one key:
\tabular{ll}{
Symbol:      \tab The ticker symbol for the stock.\cr
}
}
\examples{
library(tsibble)
gafa_stock
}
\keyword{datasets}
