% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estBootCIs.R
\name{estBootCIs}
\alias{estBootCIs}
\title{Bootstrapping samples to estimate mediation effects confidence intervals for continuous 
outcome and two treatment (exposure) groups.}
\usage{
estBootCIs(trt, t.seq, M, Y, t.est, deltat, replicates)
}
\arguments{
\item{trt}{a vector indicating treatment group}

\item{t.seq}{a vector of time points at each obs}

\item{M}{matrix of mediator values}

\item{Y}{matrix of outcome values}

\item{t.est}{time points at which to make the estimation}

\item{deltat}{a small constant which controls the time-lag of the effect of the 
mediator on the outcome, half the time between two time points}

\item{replicates}{number of replicates for bootstrapping confidence intervals.}
}
\value{
{boot.se}{bootstrapped standard error for the estimated mediation effect}

{CI.upper}{percentile bootstrapped CI upper limit for the estimated mediation effect}

{CI.lower}{percentile bootstrapped CI lower limit for the estimated mediation effect}
}
\description{
Part of the set of internal functions for estimating bootstrapped confidence intervals 
for continuous outcome and two treatment groups when user argument \code{CI="boot"}.
}
