% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_native_types.R
\name{Any}
\alias{Any}
\alias{Logical}
\alias{Integer}
\alias{Double}
\alias{Character}
\alias{Raw}
\alias{List}
\alias{Null}
\alias{Closure}
\alias{Special}
\alias{Builtin}
\alias{Environment}
\alias{Symbol}
\alias{Pairlist}
\alias{Language}
\alias{Expression}
\alias{Function}
\alias{Factor}
\alias{Data.frame}
\alias{Matrix}
\alias{Array}
\alias{Date}
\alias{Time}
\alias{Dots}
\title{Assertion factories of package 'typed'}
\usage{
Any(length, ...)

Logical(length, null_ok = FALSE, ...)

Integer(length, null_ok = FALSE, ...)

Double(length, null_ok = FALSE, ...)

Character(length, null_ok = FALSE, ...)

Raw(length, null_ok = FALSE, ...)

List(length, each, data_frame_ok, null_ok = FALSE, ...)

Null(...)

Closure(null_ok = FALSE, ...)

Special(null_ok = FALSE, ...)

Builtin(null_ok = FALSE, ...)

Environment(null_ok = FALSE, ...)

Symbol(null_ok = FALSE, ...)

Pairlist(length, each, null_ok = TRUE, ...)

Language(null_ok = FALSE, ...)

Expression(length, null_ok = FALSE, ...)

Function(null_ok = FALSE, ...)

Factor(length, levels, null_ok = FALSE, ...)

Matrix(nrow, ncol, null_ok = FALSE, ...)

Array(dim, null_ok = FALSE, ...)

Data.frame(nrow, ncol, each, null_ok = FALSE, ...)

Date(length, null_ok = FALSE, ...)

Time(length, null_ok = FALSE, ...)

Dots(length, each, ...)

Logical(length, null_ok = FALSE, ...)

Integer(length, null_ok = FALSE, ...)

Double(length, null_ok = FALSE, ...)

Character(length, null_ok = FALSE, ...)

Raw(length, null_ok = FALSE, ...)

List(length, each, data_frame_ok = TRUE, null_ok = FALSE, ...)

Null(...)

Closure(null_ok = FALSE, ...)

Special(null_ok = FALSE, ...)

Builtin(null_ok = FALSE, ...)

Environment(null_ok = FALSE, ...)

Symbol(null_ok = FALSE, ...)

Pairlist(length, each, null_ok = TRUE, ...)

Language(null_ok = FALSE, ...)

Expression(length, null_ok = FALSE, ...)

Function(null_ok = FALSE, ...)

Factor(length, levels, null_ok = FALSE, ...)

Data.frame(nrow, ncol, each, null_ok = FALSE, ...)

Matrix(nrow, ncol, null_ok = FALSE, ...)

Array(dim, null_ok = FALSE, ...)

Date(length, null_ok = FALSE, ...)

Time(length, null_ok = FALSE, ...)

Dots(length, each, ...)
}
\arguments{
\item{length}{length of the object}

\item{...}{additional conditions, see details.}

\item{null_ok}{whether \code{NULL} values should be accepted, and not subjected to
any further check.}

\item{each}{assertion that every item must satisfy}

\item{data_frame_ok}{whether data frames are to be considered as lists}

\item{levels}{factor levels}

\item{nrow}{number of rows}

\item{ncol}{number of columns}

\item{dim}{dimensions}
}
\value{
A function, and more specifically, an assertion as defined above.
}
\description{
These functions are assertion factories, they produce assertions,
which take an object, check conditions, and
returns the input, usually unmodified (never modified with the functions
documented on this page).
}
\details{
Additional conditions can be provided :
\itemize{
\item If they are named, the name should be the name of a function to use on our
object, and the value should be the expected value.
\item If they are unnamed, they should be formulas, the right hand side should
be a condition, using \code{value} or \code{.} as a placeholder for the latter, and
the optional \code{lhs} an error message.
}

\code{Any} is the most general assertion factory, it doesn't check anything unless
provided additional conditions through \code{...}. Others use the base \verb{is.<type>} function
if available, or check that the object is of the relevant type with \code{typeof}
for atomic types, or check that the class of the checked value contains
the relevant class.

\code{Dots} should only be used to check the dots using \code{check_arg} on \code{list(...)}
or \code{substitute(...())}, which will
be the case when it's called respectively with \verb{function(... = ? Dots())}
and \verb{function(... = ?~ Dots())}
}
\examples{

\dontrun{
# fails
Integer() ? x <- 1
# equivalent to
declare("x", Integer(), value = 1)

Integer(2) ? x <- 1L

# we can use additional conditions in `...`
Integer(anyNA = FALSE) ? x <- c(1L, NA, 1L)
Integer(anyDuplicated = FALSE) ? x <- c(1L, NA, 1L)
}

Integer(2) ? x <- 11:12

\dontrun{
# We can also use it directly to test assertions
Integer() ? x <- 1
# equivalent to
declare("x", Integer(), value = 1)

Integer(2) ? x <- 1L
}

}
