% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{uktrans_get}
\alias{uktrans_get}
\title{Get Transaction Data}
\usage{
uktrans_get(
  item = "totalApplicationCountByRegion",
  region = NULL,
  regexp = TRUE,
  start_date = NULL,
  end_date = NULL,
  ...
)
}
\arguments{
\item{item}{item to select, see \code{uktrans_avail_items()} for
available items.}

\item{region}{region to select, see \code{uktrans_avail_regions()} for
available regions.}

\item{regexp}{use regular expression in sparql to search for regions.}

\item{start_date}{the start date as YYYY-MM-DD.}

\item{end_date}{the end date as YYYY-MM-DD.}

\item{...}{query modifiers passed through \code{rdf_modifiers}.}
}
\value{
Returns a tibble in long format.
}
\description{
Transaction Data is a dataset that shows how many customer applications we completed,
in the preceding month for: first registrations, leases, transfers of part,
dealings, official copies and searches. This is based on customer and location.
}
\examples{
\donttest{
uktrans_get(item = "totalApplicationCountByRegion", region = "East Anglia")

# If `region` is left as NULL then it returns all available regions
uktrans_get(item = "totalApplicationCountByRegion")

# Quering all available transaction data
uktrans_get(item = uktrans_avail_items())
}
}
