% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{spec}
\alias{spec}
\alias{s}
\title{Unnest spec}
\usage{
spec(
  selector = NULL,
  ...,
  as = NULL,
  children = NULL,
  groups = NULL,
  include = NULL,
  exclude = NULL,
  stack = NULL,
  process = NULL,
  default = NULL
)

s(
  selector = NULL,
  ...,
  as = NULL,
  children = NULL,
  groups = NULL,
  include = NULL,
  exclude = NULL,
  stack = NULL,
  process = NULL,
  default = NULL
)
}
\arguments{
\item{selector}{A shorthand syntax for an \code{include} parameter. Can be a list
or a character vector.

\enumerate{

\item When \code{selector} is a list or a character vector with length greater
than 1, each element is an include parameter at the corresponding
level. For example \code{s(c("a", "b"), ...)} is equivalent to \code{s(include = "a", s(include = "b", ...))}

\item When \code{selector} is a character of length 1 and contains "/"
characters it is split with "/" first. For instance \code{s(c("a", "b"), ...)},
\code{s("a/b", ...)} and \code{s("a", s("b", ...))} are all equivalent to the
canonical \code{s(include = "a", s(include = "b", ...))}. Components consisting
entirely of digits are converted to integers. For example \verb{s("a/2/b" ...)}
is equivalent to \code{s("a", s(2, s("b", ...)))}

\item Multiple \code{include} fields can be separated with \verb{,}. For example
\code{s("a/b,c/d")} is equivalent to \code{s("a", s(include = c("b", "c"), s("d", ...)))}

}}

\item{as}{name for this field in the extracted data.frame}

\item{children, ...}{Unnamed list of children spec. \code{...} is merged into
\code{children}. \code{children} is part of the canonical spec.}

\item{groups}{Named list of specs to be processed in parallel. The return
value is a named list of unnested data.frames. The results is the same as
when each spec is \code{unnest}ed separately except that \code{dedupe} parameter of
\code{unnest()} will work across groups and execution is faster because the
nested list is traversed once regardless of the number of groups.}

\item{include, exclude}{A list, a numeric vector or a character vector
specifying components to include or exclude. A list can combine numeric
indexes and character elements to extract.}

\item{stack}{Whether to stack this node (TRUE) or to spread it (FALSE). When
\code{stack} is a string an index column is created with that name.}

\item{process}{Extra processing step for this element. Either NULL for no
processing (the default), "as_is" to return the entire element in a list
column, "paste" to paste elements together into a character column.}

\item{default}{Default value to insert if the \code{include} specification hasn't
matched.}
}
\value{
\code{s()}: a canonical spec - a list consumed by C++ unnesting routines.
}
\description{
Unnest spec is a nested list with the same structure as the
nested json. It specifies how the deeply nested lists ought to be
unnested. \code{spec()} is a handy constructor for spec lists. \code{s()} is a
shorthand alias for \code{spec()}.
}
\examples{

s("a")
s("a//c2")
s("a/2/c2,cid")

}
