% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustfd_endpoints.R
\name{ustfd_field_dictionary}
\alias{ustfd_field_dictionary}
\title{Return a table of known fields for known endpoints}
\source{
\url{https://fiscaldata.treasury.gov/api-documentation/#fields-by-endpoint}
}
\usage{
ustfd_field_dictionary(endpoint)
}
\arguments{
\item{endpoint}{a string representing a valid endpoint}
}
\value{
tibble
}
\description{
\code{ustfd_endpoints} returns the field dictionaries for the requested endpoint.
See \code{\link[=ustfd_endpoints]{ustfd_endpoints()}} for known endpoints.
}
\details{
The format of a dictionary is a tibble with one row for every field and
the following columns:
\itemize{
\item \code{field_name} - the field name recognizable to the API interface
\item \code{label} - a descriptive label
\item \code{data_type} - one of: "DATE", "STRING", "CURRENCY", "NUMBER",
"PERCENTAGE", "YEAR", "QUARTER", "MONTH", "DAY"
\item \code{data_format} - a description of the data format returned by the API
}
}
\examples{
library(ustfd)
ustfd_field_dictionary()[[ustfd_endpoints()$endpoint[4]]]



}
\seealso{
Other ustfd_user: 
\code{\link{ustfd_endpoints}()},
\code{\link{ustfd_query}()},
\code{\link{ustfd_simple}()}
}
\concept{ustfd_user}
