% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericrules.R
\name{do_by}
\alias{do_by}
\alias{sum_by}
\alias{mean_by}
\alias{min_by}
\alias{max_by}
\title{split-apply-combine for vectors, with equal-length outptu}
\usage{
do_by(x, by, fun, ...)

sum_by(x, by, na.rm = FALSE)

mean_by(x, by, na.rm = FALSE)

min_by(x, by, na.rm = FALSE)

max_by(x, by, na.rm = FALSE)
}
\arguments{
\item{x}{A bare variable name}

\item{by}{a bare variable name, or a list of bare variable names, used to
split \code{x} into groups.}

\item{fun}{\code{[function]} A function that aggregates \code{x} to a single value.}

\item{...}{passed as extra arguments to \code{fun} (e.g. \code{na.rm=TRUE}}

\item{na.rm}{Toggle ignoring \code{NA}}
}
\description{
Group \code{x} by one or more categorical variables, compute
an aggregate, repeat that aggregate to match the size of the
group, and combine results. The functions \code{sum_by} and 
so on are convenience wrappers that call \code{do_by} internally.
}
\examples{
x <- 1:10
y <- rep(letters[1:2], 5)
do_by(x, by=y, fun=max)
do_by(x, by=y, fun=sum)

}
\seealso{
Other cross-record-helpers: 
\code{\link{contains_exactly}()},
\code{\link{exists_any}()},
\code{\link{hb}()},
\code{\link{hierarchy}()},
\code{\link{is_complete}()},
\code{\link{is_linear_sequence}()},
\code{\link{is_unique}()}
}
\concept{cross-record-helpers}
