% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HydrophilicityEvaluation.R
\name{HydrophilicityEvaluation}
\alias{HydrophilicityEvaluation}
\title{Hydrophilicity Evaluation}
\usage{
HydrophilicityEvaluation(prefix = "alignTesting/",
  h2o.prot.dist.max = 6, bound.h2o.dist.max = 4, min.num.h2o = 20,
  probeRadius = 1.4, dataset = "top56")
}
\arguments{
\item{prefix}{The directory containing the protein structures; \emph{e.g.},
"alignTesting/"}

\item{h2o.prot.dist.max}{Maximum distance between the water oxygen atoms and
the protein for consideration in the determination for hydrophilicity
values; default: 6.0}

\item{bound.h2o.dist.max}{Maximum distance between the water oxygen atoms and
the protein for inclusion in the calculation of hydrophilicity values;
default: 4.0}

\item{min.num.h2o}{Minimum number of water oxygen atoms within a protein
structure for it to be included in the calculation of hydrophilicity
values; default: 20}

\item{probeRadius}{Water molecule probe radius; default: 1.4}

\item{dataset}{Name of the dataset to be used; \emph{e.g.},"top56"}
}
\value{
This function returns:
\itemize{
\item \strong{PDB.info}: a summary of the data for each protein structure analyzed
\itemize{
\item \emph{PDBid}: PDB id
\item \emph{time}: duration for hydrophilicity evaluation
\item \emph{num.res}: number of protein residues
\item \emph{num.res.buried}: number of protein residues with \emph{\strong{NO}} solvent
exposure
\item \emph{num.res.SurExp}: number of protein residues with solvent accessible
surface area
\item \emph{pct.res.SurExp}: percentage of protein residues with solvent
\item \emph{SASA.total}: total protein solvent accessible surface area;
Angstroms^2^
\item \emph{SASA.lost}: total protein solvent accessible surface area lost due to
bound waters; Angstroms^2^
\item \emph{pct.SASA.exposed}: percentage protein solvent accessible surface area
\eqn{(SASA.total - SASA.lost) / SASA.total}
\item \emph{num.prot.atom}: number of protein atoms
\item \emph{num.atom.buried}: number of protein atoms with \emph{\strong{NO}} solvent
exposure
\item \emph{num.atom.SurExp}: number of protein atoms with solvent accessible
surface area
\item \emph{pct.atom.SurExp}: percentage protein atoms with solvent accessible
surface area \eqn{(SASA.total - SASA.lost) / SASA.total}
\item \emph{num.h2o}: number of waters in the system
\item \emph{num.h2o.lte.prot.max}: number of waters within \code{h2o.prot.dist.max}
cutoff
\item \emph{num.SurBound.h2o}: number of surface bound waters; water within
\code{bound.h2o.dist.max} cutoff
\item \emph{num.bb.h2o.inter}: number of backbone - water interactions
\item \emph{num.sc.h2o.inter}: number of sidechain - water interactions
\item \emph{num.res.h2o.inter}: number of interactions between residues and water
\item \emph{num.h2o.res.inter}: number of interactions between water and residue
(residues are a unit)
\item \emph{num.h2o.resAtom.inter}: number of water-atom interactions
}
\item \strong{SASA.results}: \code{data.frame} of protein atoms within the
\code{h2o.prot.dist.max} of each water oxygen atom
\item \strong{df.AtomTypes.all}: total number of AtomTypes for each structure
\item \strong{df.AtomTypes.buried}: number of buried AtomTypes for each structure
\item \strong{df.AtomTypes.SurExp}: number of surface exposed AtomTypes for each
structure
\item \strong{df.AtomTypes.h2o.nearby}: number of surface exposed AtomTypes within
h2o.prot.dist.max (default 6 Ang) of an individual water
\item \strong{df.AtomTypes.h2o.bound}: number of surface exposed AtomTypes within
bound.h2o.dist.max (default 4 Ang) of an indvidual water
\item \strong{df.AtomTypes.h2o.inter}: number of surface exposed AtomTypes with the
shortest distance to an individual water
\item \strong{df.residue.hydro}:
\item \strong{HydrophilicityTable}: hydrophilicity table based on provided protein
structures
\item \strong{AtomTypeClasses.hydratFract}:
\item \strong{no.h2o}: proteins (PDB IDs) without the \emph{minimum} number of user
defined waters \code{min.num.h2o}
\item \strong{call}: parameters provided by the user
\item \strong{duration}: duration of complete \code{\link[=HydrophilicityEvaluation]{HydrophilicityEvaluation()}}
calculation
}
}
\description{
Calculate the hydrophilicity values for a set of protein
structures.
}
\details{
The hydrophilicity values of individual atomtypes is determined
using a collection of protein structures. For each water oxygen atom within
at the most 4 Angstroms of a solvent accessible (exposed) protein atom,
these occurrences are recorded. The number of solvent accessible atom types
interacting with a water molecule are divided by the number of solvent
accessible atom types. In general the more diverse data available, the
better the informatics based hydrophilicity values should correlate with
various experimental values.

\emph{\strong{NOTE}}: Hydrogen atoms are removed for instances when the protein
structures have not be cleaned with \code{\link[=CleanProteinStructures]{CleanProteinStructures()}}.
}
\examples{
\dontrun{
 HydrophilicityEvaluation <- function(prefix = "alignTesting/",
                                      h2o.prot.dist.max = 6.0,
                                      bound.h2o.dist.max = 4.0,
                                      min.num.h2o = 20,
                                      probeRadius = 1.4,
                                      dataset = "top56")
}

}
\references{
Leslie A Kuhn, Craig A Swanson, Michael E Pique, John A Tainer,
and Elizabeth D Getzof. Atomic and Residue Hydrophilicity in the Context of
Folded Protein Structures. \emph{PROTEINS: Structure, Function, and
Genetics}, 1995, \strong{23} (\emph{4}), pp 536-547.
\href{http://doi.org/10.1002/prot.340230408}{DOI: 10.1002/prot.340230408}
\href{http://www.ncbi.nlm.nih.gov/pubmed/8749849}{PMID: 8749849}
}
\seealso{
Other "Hydrophilicity Evaluation" "Bound Water Environment": \code{\link{calcAtomClassHydrophilicity}},
  \code{\link{calcAtomHydrationEstimate}},
  \code{\link{getProtAtomsNearWater}},
  \code{\link{getResidueData}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Hydrophilicity Evaluation" "Bound Water Environment"}
