% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundWaterEnvironments.R
\name{calcNumHydrogenBonds}
\alias{calcNumHydrogenBonds}
\title{Calculate Number of Hydrogen Bonds}
\usage{
calcNumHydrogenBonds(distances, nearby.atoms.idc, names.atoms, set.oi.idc)
}
\arguments{
\item{distances}{between water atom of interest and the protein atoms, water
oxygen atoms, or HETATMs}

\item{nearby.atoms.idc}{numeric vector of atom indices near water of interest}

\item{names.atoms}{names of atoms; \emph{e.g.}; c("CB", "CA", "N", "O", "CZ")}

\item{set.oi.idc}{numeric vector of indices for protein atoms, water oxygen
atoms, or HETATMs}
}
\value{
Number of possible hydrogen bonds between the water of interest and
the protein atoms within 3.5 Angstroms of the water.
}
\description{
Calculate the number of hydrogen bonds.
}
\details{
The summation, mean, and standard deviation of the hydrophilicity
fraction for the protein atoms within the user specified distance for the
\code{\link[=BoundWaterEnvironment]{BoundWaterEnvironment()}} function are calculated and returned.
}
\examples{
  \dontrun{
  distances <- PDB.1hai.h2o.prot.dists[3, ]
  nearby.atoms.idc <- Nearby(distances, set.idc = prot.idc, radius = 3.6)
  names.atoms <- PDB.1hai.aoi.clean$elety[prot.idc]
  calcNumHydrogenBonds(distances, nearby.atoms.idc, names.atoms,
    set.oi.idc = prot.idc)
  # [1] 4
  }

}
\seealso{
Other "Bound Water Environment": \code{\link{BoundWaterEnvironment.interact}},
  \code{\link{BoundWaterEnvironment.quality}},
  \code{\link{BoundWaterEnvironment}},
  \code{\link{Mobility}}, \code{\link{NormalizedBvalue}},
  \code{\link{calcBvalue}},
  \code{\link{calcNearbyHydrationFraction}}
}
\author{
Emilio Xavier Esposito \email{emilio@exeResearch.com}
}
\concept{"Bound Water Environment"}
