% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minque.R
\name{minque}
\alias{minque}
\title{MINQUE estimation of variance components}
\usage{
minque(y, X, Kerns, n.iter = 1, eps = 0.001)
}
\arguments{
\item{y}{Numeric vector of traits. Only continuous trait currently allowed.}

\item{X}{Matrix of covariates (columns) for subjects (rows), matching subjects in the trait (y) vector.}

\item{Kerns}{List of kernel matrices: a kernel matrix for each  variance compenent. The last kernel matrix in the list (an identity matrix) is for the residual variance component.}

\item{n.iter}{Number of  minque iterations}

\item{eps}{Default small positive value for non-positive vc estimates within iterations.}
}
\value{
List with estimates of variance components (vc), covariate regression coefficients (beta), and residuals of model fit.
}
\description{
Estimate variance components by MINQUE method, allowing multiple iterations
}
\examples{
data(vcexample)
nvc <- 1+length(unique(doseinfo[,2]))
id <- 1:nrow(dose)
## vcs for genetic kernel matrices
Kerns <- vector("list", length=nvc)
for(i in 1:(nvc-1)){
  Kerns[[i]] <- kernel_linear(dose[,grep(i, doseinfo[,2])])
  rownames(Kerns[[i]]) <- id
  colnames(Kerns[[i]]) <- id
}
## vc for residual variance
Kerns[[nvc]] <- diag(nrow(dose))
rownames(Kerns[[nvc]]) <- id
colnames(Kerns[[nvc]]) <- id
prefit  <- minque(response, covmat, Kerns, n.iter=2)
prefit[1]
prefit[2]
fit <- vcpen(response, covmat, Kerns, vc_init = prefit$vc)

}
\author{
JP Sinnwell, DJ Schaid
}
