% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\encoding{UTF-8}
\name{add_data}
\alias{add_data}
\title{Add data to a Vega-Lite spec}
\usage{
add_data(vl, source, format_type = NULL)
}
\arguments{
\item{vl}{a Vega-Lite object}

\item{source}{you can specify a (fully qualified) URL or an existing
\code{data.frame} (or \code{ts}) object or a reference to a local file.
For the URL case, the \code{url} component of \code{data} will be set. You can help
Vega-Lite out by giving it a hint for the data type with \code{format_type}
but it is not required. For the local \code{data.frame} case it will embed
the data into the spec. For the case where a local file is specified, it
will be read in (either a JSON file, CSV file or TSV file) and converted
to a \code{data.frame} and embedded.}

\item{format_type}{if \code{source} is a URL, this should be one of \code{json},
\code{csv} or \code{tsv}). It is not required and it is ignored if \code{source}
is not a URL.}
}
\description{
Vega-Lite is more lightweight than full Vega. However, the spec is
flexible enough to support embedded data or using external sources that
are in JSON, CSV or TSV format.
}
\examples{
dat <- jsonlite::fromJSON('[
    {"a": "A","b": 28}, {"a": "B","b": 55}, {"a": "C","b": 43},
    {"a": "D","b": 91}, {"a": "E","b": 81}, {"a": "F","b": 53},
    {"a": "G","b": 19}, {"a": "H","b": 87}, {"a": "I","b": 52}
  ]')

vegalite() \%>\%
  add_data(dat) \%>\%
  encode_x("a", "ordinal") \%>\%
  encode_y("b", "quantitative") \%>\%
  mark_bar()
}
\references{
\href{http://vega.github.io/vega-lite/docs/data.html}{Vega-Lite Data spec}
}

