% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-javascript.R
\name{glue_js}
\alias{glue_js}
\title{Interpolate into a JavaScript string}
\usage{
glue_js(..., .open = "${", .envir = parent.frame())
}
\arguments{
\item{...}{character vectors as the JavaScript source code (all arguments
will be pasted into one character string)}

\item{.open}{\code{character}, opening delimiter used by \code{\link[glue:glue]{glue::glue()}}}

\item{.envir}{\code{environment}, tells \code{\link[glue:glue]{glue::glue()}} where to find
the variables to be interpolated}
}
\value{
\code{glue::glue()} object
}
\description{
Uses JavaScript notation to interpolate R variables into a string
intended to be interpreted as JS.
}
\details{
This is a wrapper to \code{\link[glue:glue]{glue::glue()}}, but it uses the notation used by
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals}{JavaScript's template-literals},
\verb{$\{\}}.
}
\examples{
  x <- 123
  glue_js("function(){return(${x});}") \%>\% print()
}
