% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql.R
\name{sql_collect}
\alias{sql_collect}
\title{Query and get data back into a data.frame}
\usage{
sql_collect(src, query, ...)
}
\arguments{
\item{src}{(src) An \code{src} object, result of calling \code{\link[=src_germansl]{src_germansl()}},
\code{\link[=src_eurosl]{src_eurosl()}}}

\item{query}{(character) A SQL query}

\item{...}{further args passed on to \code{\link[dplyr:tbl]{dplyr::tbl()}}}
}
\description{
Query and get data back into a data.frame
}
\details{
we run \code{\link[dplyr:tbl]{dplyr::tbl()}}, then \code{\link[dplyr:compute]{dplyr::collect()}}
}
\examples{
\dontrun{
src <- src_germansl()
sql_collect(src, "select * from GermanSL limit 5")
## or pipe the src to sql_collect
src \%>\% sql_collect("select * from GermanSL limit 5")
}
}
