% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_eea.R
\name{ef_eea}
\alias{ef_eea}
\title{Emissions factors from European European Environment Agency}
\usage{
ef_eea(category, fuel, segment, euro, tech, pol, mode, slope, load, speed)
}
\arguments{
\item{category}{String: "Passenger Cars", "Light Commercial Vehicles", "Heavy Duty Trucks",
"Buses" or "L-Category".}

\item{fuel}{String;  "Petrol", "Petrol Hybrid", "Petrol PHEV ~ Petrol",
"Petrol PHEV ~ Electricity",  "Diesel", "Diesel PHEV ~ Diesel",
"Diesel PHEV ~ Electricity", "LPG Bifuel ~ LPG", "LPG Bifuel ~ Petrol",
"CNG Bifuel ~ CNG", "CNG Bifuel ~ Petrol", "Diesel Hybrid ~ Diesel",
"Diesel Hybrid ~ Electricity", "CNG", "Biodiesel"}

\item{segment}{String for type of vehicle.}

\item{euro}{String; euro standard.}

\item{tech}{String; technology.}

\item{pol}{String; "CO", "NOx", "VOC", "PM Exhaust", "EC", "CH4", "NH3", "N2O"}

\item{mode}{String; "Urban Peak", "Urban Off Peak", "Rural", "Highway", NA.}

\item{slope}{Numeric; 0.00, -0.06, -0.04, -0.02,  0.02,  0.04,  0.06, or NA}

\item{load}{Numeric; 0.0,0.5, 1.0 or NA}

\item{speed}{Numeric; optional numeric in km/h.}
}
\value{
Return a function depending of speed or numeric (g/km)
}
\description{
\code{\link{ef_cetesb}} returns a vector or data.frame of Brazilian emission factors.
}
\examples{
\dontrun{
# ef_eea(category = "I DONT KNOW")
ef_eea(category = "Passenger Cars",
fuel = "Petrol",
segment = "Small",
euro = "Euro 1",
tech = NA,
pol = "CO",
mode = NA,
slope = 0,
load = 0)(10)
}
}
\keyword{emission}
\keyword{factors}
