% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-colorfilters.R
\name{discreteColorFilter}
\alias{discreteColorFilter}
\title{Add a visual filter input for discrete values}
\usage{
discreteColorFilter(inputId, ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{...}{
  Arguments passed on to \code{\link[=numericLegend]{numericLegend}}
  \describe{
    \item{\code{label}}{Display label for the control, or \code{NULL} for no label.}
    \item{\code{class}}{The CSS class of the input div element to match with any brush-defining functions. Default classes for brushes are either \code{"continuous-color-filter"} or \code{"discrete-color-filter"}.}
    \item{\code{n}}{Number of color strips in the legend. Default is \code{100}.}
    \item{\code{minValue}}{Minimum numeric value in the legend (can be higher the maximum for inverted scale).}
    \item{\code{maxValue}}{Maximum numeric value in the legend (can be lower the minimum for inverted scale).}
    \item{\code{data}}{Alternative vector to extract numeric minimum and maximum values.}
    \item{\code{colors}}{Colours to interpolate; must be a valid argument to
\code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}. This can be a character vector of
\code{"#RRGGBB"} or  \code{"#RRGGBBAA"}, colour names from
\code{\link[grDevices:colors]{grDevices::colors()}}, or a positive integer that indexes into
\code{\link[grDevices:palette]{grDevices::palette()}}.}
    \item{\code{palette}}{A function that outputs a list of colors}
    \item{\code{options}}{Configuration options for brush and scale. Use \code{ticks} to specify number of ticks or a list of specific tick values
, \code{format} to a d3-format-compatible formatting string (see \url{https://github.com/d3/d3-format} for valid formats) and
\code{hide_brush_labels} as \code{TRUE} to hide the brush interval.}
    \item{\code{orient}}{Orientation of the legend. Can be \code{"bottom"} (default, horizontal with labels below), \code{"top"} (horizontal with labels above), \code{"left"} (vertical with labels on the left)
and \code{"right"} (vertical with labels on the right).}
    \item{\code{size}}{Absolute length in pixels of the color bar; becomes width or height depending on value of \code{orient}. Default is \code{200}.}
    \item{\code{thickness}}{Absolute thickness in pixels of the color bar; opposite of size depending on value of \code{orient}. Default is \code{20}.}
    \item{\code{offset}}{Left offset for scale to allow long labels. Default is \code{0}.}
  }}
}
\value{
A visual filter input control that can be added to a UI definition.
}
\description{
The brush used in this filter snaps to evenly divided steps based on the number of colors passed as argument.
With minValue = 0, maxValue = 100 and n = 5, it will snap at the edges (0 and 100) and 20, 40, 60, and 80.
}
\section{Server value}{

\code{start} and \code{end} bounds of a selection. The input value is \code{NULL} for empty selections.


\code{start} and \code{end} bounds of a selection. The default value is null.
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  discreteColorFilter("filter", minValue = 0, maxValue = 200, n = 5,
                        palette = scales::viridis_pal()),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- output$selection <- renderPrint({
  if (!is.null(input$filter)) {
    paste0(input$filter$start, ",", input$filter$end)
  }
})
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link[=numericLegend]{numericLegend()}}

Other visual filters: 
\code{\link{categoricalColorFilter}()},
\code{\link{continuousColorFilter}()}
}
\concept{visual filters}
