% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot_effects}
\alias{plot_effects}
\title{Plot marginal effects of a D-vine regression model}
\usage{
plot_effects(object, alpha = c(0.1, 0.5, 0.9), vars = object$order)
}
\arguments{
\item{object}{a \code{vinereg} object}

\item{alpha}{vector of quantile levels.}

\item{vars}{vector of variable names.}
}
\description{
The marginal effects of a variable is the expected effect, where expectation
is meant with respect to all other variables.
}
\examples{
# simulate data
x <- matrix(rnorm(200), 100, 2)
y <- x \%*\% c(1, -2)
dat <- data.frame(y = y, x = x, z = as.factor(rbinom(100, 2, 0.5)))

# fit vine regression model
fit <- vinereg(y ~ ., dat)
plot_effects(fit)
}
