% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdc_minmax.R
\name{cdc_minmax}
\alias{cdc_minmax}
\title{Minmax Method}
\usage{
cdc_minmax(x, allow_dup = TRUE, min_valid = 1, variant = 1)
}
\arguments{
\item{x}{it accepts the following types of input:
1st, it can be an object of class \code{vote}. 
2nd, it can be a user-given Condorcet matrix, 
3rd, it can be a result of another Condorcet method, 
which is of class \code{condorcet}.}

\item{allow_dup}{whether ballots with duplicated score values 
are taken into account. Default is TRUE.}

\item{min_valid}{default is 1. If the number of valid entries of 
a ballot is less than this value, it will not be used.}

\item{variant}{should be 1, 2 or 3. 1 (default) for winning votes 
method, 2 for margins method, 3 for pairwise comparison method.}
}
\value{
a \code{condorcet} object, which is essentially 
a list.
\itemize{
  \item (1) \code{call} the function call.
  \item (2) \code{method} the counting method.
  \item (3) \code{candidate} candidate names.
  \item (4) \code{candidate_num} number of candidate.
  \item (5) \code{ballot_num} number of ballots in x. When 
x is not a \code{vote} object, it may be NULL.
  \item (6) \code{valid_ballot_num} number of ballots that are 
actually used to compute the result. When 
x is not a \code{vote} object, it may be NULL.
  \item (7) \code{winner} the winners.
  \item (8) \code{input_object} the class of x. 
  \item (9) \code{cdc} the Condorcet matrix which is actually used.
  \item (10) \code{dif} the score difference matrix. When 
x is not a \code{vote} object, it may be NULL.
  \item (11) \code{binary} win and loss recorded with 1 (win), 
0 (equal) and -1 (loss).
  \item (12) \code{summary_m} times of win (1), equal (0) 
and loss (-1).
  \item (13) \code{other_info} a list of 4 elements. The 1st is 
the method, which is equal to \code{variant}. The 2nd is the 
winning votes matrix. The 3rd is the margins matrix. The 4th 
is the pairwise comparison matrix.
}
}
\description{
Minmax method (also known as Simpson-Kramer method, 
successive reversal method) 
means three different methods.
The first is winning votes method. In pairwise comparison, 
if a wins b, a gets 0 point, the number of points for b is the 
number of voters who prefer a than b. 
The second method is to use margins. In pairwise comparison, 
a gets b - a points and b gets a - b points. 
The third method is pairwise opposition method. The number 
of points for a is the number of voters who prefer b than a; the 
number of points for b is the number of voters who prefer a 
than b. 
Although the point-assigning methods are different for the 
above three methods, they nonetheless do the same thing: 
to check to what extent one candidate is defeated by others. 
So the summarizing method is the same: for each candidate, 
we extract the maximum target points, and the one with the 
minimum points wins.
}
\examples{
raw <- c(
    rep(c('m', 'n', 'c', 'k'), 42), rep(c('n', 'c', 'k', 'm'), 26), 
    rep(c('c', 'k', 'n', 'm'), 15), rep(c('k', 'c', 'n', 'm'), 17)
) 
raw <- matrix(raw, ncol = 4, byrow = TRUE)
vote <- create_vote(raw, xtype = 2, candidate = c('m', 'n', 'k', 'c'))
win1 <- cdc_simple(vote)
win2 <- cdc_minmax(vote) # winner is n
win3 <- cdc_minmax(win1, variant = 2)
win4 <- cdc_minmax(win3$cdc, variant = 3)
}
\references{
\itemize{
  \item https://en.wikipedia.org/wiki/Minimax_Condorcet_method
}
}
