% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_autoid_copy}
\alias{vpr_autoid_copy}
\title{Copy VPR images into folders}
\usage{
vpr_autoid_copy(basepath, day, hour, classifier_type, classifier_name, taxa)
}
\arguments{
\item{basepath}{A file path to your autoid folder where VP data is stored eg. "C:\\\\data\\\\cruise_XXXXXXXXXXXXXXX\\\\autoid\\\\"}

\item{day}{character string representing numeric day of interest}

\item{hour}{character string representing hour of interest}

\item{classifier_type}{character string representing the type of classifier (either 'svm', 'nn' or 'dual') from Visual Plankton}

\item{classifier_name}{character string representing name of Visual Plankton classifier}

\item{taxa}{optional list of character strings if you wish to only copy images from specific classification groups}
}
\value{
organized file directory where VPR images are contained with folders, organized by day, hour and classification,
inside your basepath/autoid folder
}
\description{
Organize VPR images into folders based on classifications provided by visual plankton
}
