% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workitem.R
\name{vsts_get_workitem_fields}
\alias{vsts_get_workitem_fields}
\title{Azure DevOps Work Item Fields}
\usage{
vsts_get_workitem_fields(
  System.Title,
  System.Description,
  System.TeamProject,
  System.AreaPath,
  System.IterationPath,
  Microsoft.VSTS.Common.Priority,
  ...
)
}
\arguments{
\item{System.Title}{[character] title of the Azure DevOps work item}

\item{System.Description}{[character] description of the Azure DevOps work item}

\item{System.TeamProject}{[character] name of the Azure DevOps project}

\item{System.AreaPath}{[character] path of the Azure DevOps work item}

\item{System.IterationPath}{[character] name of the Azure DevOps iteration path}

\item{Microsoft.VSTS.Common.Priority}{[integer] priority of the work item - 1 to 4}

\item{...}{other fields that might have been missed out originally}
}
\description{
This contains all the fields required of any work item in a visual studio project and helps
add/rename the fields of the selected work item.
}
\details{
For more information about work item fields API calls check
\url{https://docs.microsoft.com/en-us/rest/api/azure/devops/wit/Fields}.
}
