% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhiteNoise.R
\name{simGARCH}
\alias{simGARCH}
\title{GARCH process}
\usage{
simGARCH(n, c, A, B = NULL, ninit = 100)
}
\arguments{
\item{n}{Number of observations.}

\item{c}{Positive number.}

\item{A}{Vector of ARCH coefficients >=0.}

\item{B}{Vector of GARCH coefficients >=0. If \code{NULL}, the
simulation is a ARCH process.}

\item{ninit}{Length of 'burn-in' period.}
}
\value{
Vector of size \code{n} containing  a nonlinear sequence \eqn{\epsilon_t} such as
  \deqn{\epsilon_{t} = H_{t}^{1 / 2}  \eta_{t}} where \deqn{H_{t} =  c +
  a_{1}\epsilon_{t - 1}^ {2}+...+a_{q}\epsilon_{t - q} ^{2} + b_{1}H_{t-1}+...+ b_{p}H_{t-p}}
}
\description{
Simulates a GARCH process which is an example of a weak white noise.
}
\examples{
simGARCH(100, c = 1, A = 0.25)
simGARCH(100, c = 1, A = 0.1,  B = 0.88)
}
\references{
Francq C. and Zakoïan J.M., 2010, \emph{GARCH models: structure, statistical inference and financial applications}
}
\seealso{
\code{\link{wnRT}}, \code{\link{wnPT}}, \code{\link{wnPT_SQ}}
}
