% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{smart_options}
\alias{smart_options}
\title{Creates HTML option tags for each position of a list of values and labels by calling html5::option(), returning a string of HTML to pass to a select tag through html5::select().}
\usage{
smart_options(x, value, label, selected_value, add_blank = FALSE)
}
\arguments{
\item{x}{A named list, one name should refer to a vector of values, one name should refer to a vector of labels equal in length to the values.}

\item{value}{The name of the position in x to use as the value attribute for each option tag.}

\item{label}{The name of the position in x to use as the displayed content for each option tag.}

\item{selected_value}{A value in the vector passed as value to mark as the initially selected option in the select tag.}

\item{add_blank}{TRUE/FALSE, if TRUE, adds a blank ("") option tag.}
}
\value{
A string, with an option tag each row of x.
}
\description{
Creates HTML option tags for each position of a list of values and labels by calling html5::option(), returning a string of HTML to pass to a select tag through html5::select().
}
\examples{
smart_options(
x = list(col1 = c("1", "2", "3"), col2 = c("New York", "Los Angeles", "Chicago")),
value = "col1",
label = "col2",
selected_value = "3",
add_blank = TRUE
)
}
