\name{x_and_d}
\alias{x_and_d}
\alias{x}
\alias{d}
\docType{data}
\title{Generating elements for the first Weyl algebra}
\description{\loadmathjax

  Variables \code{x} and \code{d} correspond to operator \mjseqn{x} and
  \mjeqn{\partial_x}{omitted}; they are provided for convenience.  These
  elements generate the one-dimensional Weyl algebra.

  Note that a similar system for multivariate Weyl algebras is not
  desirable.  We might want to consider the Weyl algebra generated by
  \mjeqn{\left\lbrace
  x,y,z,\partial_x,\partial_y,\partial_z\right\rbrace}{\{x,y,z,dx,dy,dz\}}
  and correspondingly define R variables \code{x,y,z,dx,dy,dz}.  But
  then variable \code{x} is ambiguous: is it a member of the first Weyl
  algebra or the third?

}
\usage{data(x_and_d)}
\author{Robin K. S. Hankin}
\examples{
d*x-x*d

(1-d*x*d)*(x^2-d^3)

}
\keyword{datasets}
