% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wheatmap.R
\name{WHeatmap}
\alias{WHeatmap}
\title{WHeatmap object}
\usage{
WHeatmap(
  data = NULL,
  dm = NULL,
  name = "",
  continuous = NULL,
  cmp = NULL,
  cm = NULL,
  xticklabels = NULL,
  xticklabels.n = NULL,
  xticklabel.side = "b",
  xticklabel.fontsize = 12,
  xticklabel.rotat = 90,
  xticklabel.pad = 0.005,
  xticklabel.space = 0.05,
  xticklabel.use.data = FALSE,
  yticklabels = NULL,
  yticklabels.n = NULL,
  yticklabel.side = "l",
  yticklabel.fontsize = 12,
  yticklabel.rotat = 0,
  yticklabel.pad = 0.005,
  yticklabel.space = 0.05,
  yticklabel.use.data = FALSE,
  sub.name = NULL,
  bbox = FALSE,
  gp = NULL
)
}
\arguments{
\item{data}{data matrix}

\item{dm}{plotting dimension (a WDim or a WDimGenerator object)}

\item{name}{name of the plot}

\item{continuous}{whether the data should be treated as continuous or discrete}

\item{cmp}{a CMPar object, for tunning color mapping parameters}

\item{cm}{a given color map}

\item{xticklabels}{to plot xtick labels, one may supply characters to plot just a subset of xtick labels}

\item{xticklabels.n}{number of xtick labels to plot (resample for aethetics by default)}

\item{xticklabel.side}{xticklabel side (t or b)}

\item{xticklabel.fontsize}{xticklabel font size}

\item{xticklabel.rotat}{xticklabel rotation}

\item{xticklabel.pad}{padding between xticklabel and x-axis}

\item{xticklabel.space}{xticklabel space}

\item{xticklabel.use.data}{use data to label x-axis (most likely used by colorbar)}

\item{yticklabels}{to plot ytick labels, one may supply characters to plot just a subset of ytick labels}

\item{yticklabels.n}{number of ytick labels to plot (resample for aethetics by default)}

\item{yticklabel.side}{yticklabel side (l or r)}

\item{yticklabel.fontsize}{yticklabel font size}

\item{yticklabel.rotat}{yticklabel rotation}

\item{yticklabel.pad}{padding between yticklabel and y-axis}

\item{yticklabel.space}{yticklabel space}

\item{yticklabel.use.data}{use data to label y-axis (most likely used by colorbar)}

\item{sub.name}{subclass name}

\item{bbox}{whether to plot the boundary box (useful with white matrix elements)}

\item{gp}{a list of graphical parameters}
}
\value{
one or a list of heatmaps (depends on whether dimension is split)
}
\description{
Create a heatmap
}
\examples{
WHeatmap(matrix(1:10, nrow=2), cmp=CMPar(brewer.name='Greens'))

WHeatmap(matrix(1:12,nrow=2), cmp=CMPar(brewer.name='Greens'), name='a') + 
    WHeatmap(matrix(1:6,nrow=1), Beneath(pad=0.05), cmp=CMPar(brewer.name='Set2'), name='b') +
    WHeatmap(matrix(c(1:30,30:1),nrow=5), Beneath(pad=0.05), 'c', cmp=CMPar(cmap='jet')) +
    WHeatmap(matrix(1:24,nrow=4), RightOf('c'), 'd', cmp=CMPar(brewer.name='Set1')) +
    WLegendV('c', LeftOf('c', pad=0.01), yticklabel.side='l') +
    WLegendV('b', RightOf('b', width=0.1)) + 
    WLegendV('a', RightOf('a')) + 
    WHeatmap(matrix(1:100, nrow=10), RightOf('d'), cmp=CMPar(brewer.name='RdYlGn')) +
    WColorBarH(matrix(5:1), TopOf(), cmp=CMPar(colorspace.name = 'diverge_hcl')) +
    WColorBarH(matrix(50:1), TopOf(), cmp=CMPar(colorspace.name = 'terrain_hcl')) +
    WColorBarH(matrix(1:8), TopOf(), cmp=CMPar(colorspace.name = 'sequential_hcl')) +
    WColorBarH(matrix(1:8), TopOf(), cmp=CMPar(brewer.name = 'YlOrRd'))

## One could use \%>\% too, in combination with magrittr's add function
\dontrun{
library(magrittr)
WColorBarH(1:10) \%>\% add(WColorBarV(rep(c('black','red','blue'),3), RightOf()))
}

}
