% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Zeta.decline.mc}
\alias{Zeta.decline.mc}
\title{Zeta diversity decline using Monte Carlo sampling}
\usage{
Zeta.decline.mc(
  data.spec,
  xy = NULL,
  orders = 1:10,
  sam = 1000,
  sd.correct = TRUE,
  sd.correct.adapt = FALSE,
  confint.level = 0.95,
  sd.plot = TRUE,
  rescale = FALSE,
  normalize = FALSE,
  NON = FALSE,
  FPO = NULL,
  DIR = FALSE,
  empty.row = "empty",
  plot = TRUE,
  silent = TRUE
)
}
\arguments{
\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{xy}{Site coordinates. This is only used if \code{NON} = TRUE or \code{DIR} = TRUE.}

\item{orders}{Range of number of assemblages or sites for which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta diversity is computed for each number of assemblages or sites.}

\item{sd.correct}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) or not (using the number of site combinations as the denominator).}

\item{sd.correct.adapt}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be computed with an unbiased estimator (using the number of site combinations - 1 as the denominator) if \code{sam} is higher than the number of possible combinations, or not (using the number of site combinations as the denominator) if \code{sam} is lower than the number of possible combinations. If \code{sd.correct.adapt = TRUE}, it takes precedence over \code{sd.correct}.}

\item{confint.level}{Percentage for the confidence intervals of the coefficients from the regressions.}

\item{sd.plot}{Boolean value (TRUE or FALSE) indicating if the standard deviation of each zeta diversity value must be plotted.}

\item{rescale}{Boolean value (TRUE or FALSE) indicating if the zeta values should be divided by \eqn{\zeta_1}, to get a range of values between 0 and 1. Has no effect if \code{normalize} != \code{FALSE}.}

\item{normalize}{Indicates if the zeta values for each sample should be divided by the total number of species for this specific sample (\code{normalize = "Jaccard"}), by the average number of species per site for this specific sample (\code{normalize = "Sorensen"}), or by the minimum number of species in the sites of this specific sample \cr (\code{normalize = "Simpson"}). Default value is \code{FALSE}, indicating that no normalization is performed.}

\item{NON}{Boolean value (TRUE or FALSE) indicating if the number of species in common should only be counted for the nearest neighbours.}

\item{FPO}{A vector with the coordinates of the fixed point origin from which the zeta diversity will be computed (overrides NON). In that case, \eqn{\zeta_1} is the number of species in the closest site to the FPO, \eqn{\zeta_2} is the number of species shared by the 2 closest sites, etc.}

\item{DIR}{Boolean value (TRUE or FALSE) indicating if zeta diversity must be computed using a directed nearest neighbour scheme in the direction away from the FPO, starting from any site.}

\item{empty.row}{Determines how to handle empty rows, i.e. sites with no species. Such sites can cause underestimations of zeta diversity, and computation errors for the normalized version of zeta due to divisions by 0. Options are "\code{empty}" to let the data untreated, "\code{remove}" to remove the empty rows, 0 to set the normalized zeta to 0 when zeta is divided by 0 during normalization (sites share no species, so are completely dissimilar), and 1 to set the normalized zeta to 1 when zeta is divided by 0 during normalization (i.e. sites are perfectly similar).}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}

\item{silent}{Boolean value (TRUE or FALSE) indicating if messages must be printed.}
}
\value{
\code{Zeta.decline.mc} returns a list containing the following components:

\item{zeta.order}{The number of assemblages or sites for which the zeta diversity was computed.}

\item{combinations}{The number of possible combinations of sites for the chosen orders.}

\item{zeta.val}{The zeta diversity values.}

\item{zeta.val.sd}{The zeta diversity standard deviation values.}

\item{zeta.ratio}{The ratio of zeta diversity values by the zeta diversity values at the lower order \eqn{\zeta_i / \zeta_{i-1}}.}

\item{zeta.exp}{Object of class "\code{lm}", containing the output of the exponential regression.}

\item{zeta.exp.confint}{The confidence intervals of the coefficients of the exponential regression.}

\item{zeta.pl}{Object of class "\code{lm}", containing the output of the power law regression.}

\item{zeta.pl.confint}{The confidence intervals of the coefficients of the power law regression.}

\item{aic}{AIC values for \code{zeta.exp} and \code{zeta.pl}.}
}
\description{
Computes zeta diversity, the number of species shared by multiple assemblages, for a range of orders (number of assemblages or sites), using combinations of sampled sites, and fits the decline to an exponential and a power law relationship.
}
\details{
If the number of combinations of sites is lower than the value of the parameter \code{sam}, all the combinations are used and an exact solution is computed. In that case, using the number of site combinations as the denominator may be appropriate to compute the standard deviation, if all sites were sampled and the zeta values. This can be adjusted with parameters \code{sd.correct} and \code{sd.correct.adapt}.

\code{Zeta.decline.mc} is faster than \code{\link{Zeta.decline.ex}} to compute the exact value of zeta diversity when the number of species is higher than \eqn{C^N_{i}}, where \emph{N} is the total number of sites and \emph{i} is the order of zeta.

The exponential and the power law fit are performed using linear regressions on log-transformed data (only the zeta values are log-transformed for the exponential fit, and both the orders and the zeta values are log-transformed for the power law fit).

\code{Zeta.decline.mc} enables accomodating richness heterogeneity by setting \code{normalize = "Jaccard"}, \code{normalize = "Sorensen"} or \code{normalize = "Simpson"}. This cannot be performed by \cr \code{\link{Zeta.decline.ex}}.
}
\examples{
utils::data(bird.spec.coarse)
xy.bird <- bird.spec.coarse[,1:2]
data.spec.bird <- bird.spec.coarse[,3:193]

dev.new(width = 12, height = 4)
zeta.bird <- Zeta.decline.mc(data.spec.bird, xy.bird, orders = 1:5, sam = 100,
   NON = TRUE)
zeta.bird

##########

utils::data(Marion.species)
xy.marion <- Marion.species[,1:2]
data.spec.marion <- Marion.species[,3:33]

dev.new(width = 12, height = 4)
zeta.marion <- Zeta.decline.mc(data.spec.marion, orders = 1:5, sam = 100,
     normalize = "Jaccard")
zeta.marion

}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.
}
\seealso{
\code{\link{Zeta.decline.ex}}, \code{\link{Zeta.order.ex}}, \code{\link{Zeta.order.mc}}, \code{\link{Plot.zeta.decline}}
}
