% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookup}
\alias{lookup}
\title{Lookup values from a lookup table}
\usage{
lookup(x, lookup_table)
}
\arguments{
\item{x}{A string vector whose elements shall be looked up}

\item{lookup_table}{The lookup table to use.}
}
\value{
A string vector based on \code{x}, with values replaced with the lookup
values from \code{lookup_table}. Any values not found in the lookup table are
returned unchanged.
}
\description{
The \code{\link[=lookup]{lookup()}} function implements lookup of certain strings (such as
variable names) from an lookup table which maps keys onto values (such as
variable labels or descriptions). Original values are returned if they are
not found in the lookup table.

The lookup table can be in the form of a two-column \code{data.frame}, in the form
of a named \code{vector}, or in the form of a \code{list}. If the table is in the form
of a \code{data.frame}, the lookup columns should be named \code{name} (for the key)
and \code{value} (for the value). If the lookup table is in the form of a named
\code{vector} or \code{list}, the name is used for the key, and the returned value is
taken from the values in the vector or list.

Any names in x are not included in the result.
}
\examples{
fruit_lookup_vector <- c(a="Apple", b="Banana", c="Cherry")
lookup(letters[1:5], fruit_lookup_vector)

mtcars_lookup_data_frame <- data.frame(
  name = c("mpg", "hp", "wt"),
  value = c("Miles/(US) gallon", "Gross horsepower", "Weight (1000 lbs)"))
lookup(names(mtcars), mtcars_lookup_data_frame)

}
