% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTimeWindows.R
\name{makeTimeWindows}
\alias{makeTimeWindows}
\title{Helper function that creates temporal windows in datasets}
\usage{
makeTimeWindows(inputData, timeVar, windowSize)
}
\arguments{
\item{inputData}{data.frame that has data over time, usually within a single meeting}

\item{timeVar}{name of a numeric column that contains the time variable you want to use}

\item{windowSize}{numeric value giving the length of time window}
}
\value{
list with two data.frames:
\itemize{
\item windowedData - inputData with the temporal window identifying information included
\item allWindows - contains the full set of temporal windows and identifying information. This is valuable because inputData may not have records within all of the possible temporal windows
}
}
\description{
This creates a set of temporal windows of specified size so that metrics
can be computed within those windows.
}
\examples{
win.out = makeTimeWindows(sample_transcript_processed, 
timeVar="utteranceStartSeconds", windowSize=10)
}
